﻿LREditor = {
    plugs_dic: {},
    config: {
        emotion: true,
        position: false
    },
    editor: undefined,
    load: function (id) {
        this.editor = document.getElementById(id);
        this.editor.innerHTML = "";

        var topbar = document.createElement("div");
        topbar.className = "TopBar";
        topbar.id = "TopBar";
        this.editor.appendChild(topbar);

        var econtent = document.createElement("div");

       // econtent.style.width = (this.editor.offsetWidth - 10) + "px";
        econtent.style.height = (this.editor.offsetHeight - 46) + "px";
        econtent.style.overflow = "auto";
        econtent.style.outline = "none";
        econtent.style.margin = "5px";
        econtent.className = "Content";
        econtent.id = "Content";
        this.editor.appendChild(econtent);

        this.editor.lastElementChild.contentEditable = true;

        if (this.config.emotion) {
            this.plugs_add({ "name": "emotion", "class": "emotion", "id": "emotion", "title": "表情", "showTip": true }, function (element) {

                var emotion = document.createElement("div");
                emotion.style.display = "none";
                var input = document.createElement("input");
                input.id = "emotion_focus_input";
                input.style.width = "0px";
                input.style.height = "0px";
                input.style.border = "none";
                element.appendChild(input);
                document.getElementById("emotion_focus_input").focus();

                document.getElementById("emotion_focus_input").onblur = function () {
                    setTimeout(function () { document.getElementById("emotion_close").click(); }, 100);
                };

                emotion.className = "divemotion";
                emotion.id = "divemotion";
                emotion.style.width = "505px";
                //emotion.style.height = "200px";
                emotion.style.position = "absolute";
                emotion.style.padding = "5px";
                //if (document.body.offsetHeight - LREditor.editor.offsetTop > LREditor.editor.offsetTop) {
                //    emotion.style.margin = "-7px -2px 0px -8px";
                //} else {
                //    emotion.style.margin = "-" + (LREditor.editor.clientHeight + 11) + "px -2px 0px -1px";
                //}
                emotion.style.border = "1px solid #e1e1e1";
                emotion.style.background = "#fff";
                emotion.style.borderRadius = "2px";
                var cbtn = document.createElement("div");
                cbtn.id = "emotion_close";
                cbtn.className = "emotion_close";
                emotion.appendChild(cbtn);
                cbtn.onclick = function () {
                    this.parentElement.style.display = "none";
                };
                for (var i = 1; i <= 120; i++) {
                    var ele_img = document.createElement("img");
                    //ele_img.src = "http://weixin.zoossoft.net/Data/Media/Expression/" + i + ".gif";
                    if (i <= 100) {
                        ele_img.src = "../js/LREditor/Expression/" + i + ".gif";
                    } else {
                        ele_img.src = "../js/LREditor/Expression/" + i + ".png";
                    }
                    
                    $(ele_img).css("width", "30px");
                    ele_img.onclick = function () {
                        LREditor.addExpression('<img src="' + this.src + '" />');
                        this.parentNode.style.display = "none";
                    }
                    emotion.appendChild(ele_img);
                }
                element.parentElement.appendChild(emotion);

                element.onclick = function () {
                    if (this.nextElementSibling != null) {
                        if (this.nextElementSibling.style.display == "block") {
                            this.nextElementSibling.style.display = "none";
                        } else {
                            document.getElementById("emotion_focus_input").focus();
                            document.getElementById("emotion_focus_input").onblur = function () {
                                setTimeout(function () { document.getElementById("emotion_close").click(); }, 500);
                            };
                            this.nextElementSibling.style.display = "block";
                        }
                        return;
                    }
                }
            });
        }
        if (this.config.position) {
            this.plugs_add("position", function (element) {
                element.onclick = function () {
                    alert("position");
                }
            });
        }

        return this;
    },
    plugs_add: function (obj, callback) {
        if (obj["name"] == undefined) return;
        if (this.plugs_dic[obj["name"]] != undefined) {
            alert(obj["name"] + " plugin already exists!");
            return;
        }
        var div = document.createElement("div");

        if (obj["showTip"] != undefined && obj["showTip"]) {
            div.setAttribute("data-rel", "popover");
            div.setAttribute("data-trigger", "hover");
            div.setAttribute("data-placement", "bottom");
            div.setAttribute("data-content", obj["title"]);
        }

        div.style.display = "block";
        div.style.width = "30px";
        div.style.height = "35px";
        div.style.float = "left";
        var span = document.createElement("span");


        span.className = obj["class"];
        span.id = obj["id"];
        span.title = obj["title"];
        this.plugs_dic[obj["name"]] = span;
        div.appendChild(span);
        this.editor.firstElementChild.appendChild(div);
        if (typeof (callback) == "function") {
            callback(span);
        };
    },
    getContent: function () {
        return this.editor.lastElementChild.innerHTML;
    },
    getTxtContent: function () {
        return this.editor.lastElementChild.innerText;
    },
    getPlainTxt: function () {
        var result = this.editor.lastElementChild.innerHTML;
        // 格式化掉html标签
        result = result.replace(/<div[^>]*?>/gi, "\n");
        result = result.replace(/<ul[^>]*?>/gi, "\n").replace(/<li[^>]*?>/gi, "\n")
            .replace(/<p[^>]*?>/gi, "\n\n").replace(/<h1[^>]*?>/gi, "\n\n").replace(/<h2[^>]*?>/gi, "\n\n").replace(/<h3[^>]*?>/gi, "\n\n")
            .replace(/<h4[^>]*?>/gi, "\n\n").replace(/<h5[^>]*?>/gi, "\n\n").replace(/<h6[^>]*?>/gi, "\n\n");
        result = result.replace(/<br[^>]*?>/gi, "\n");
        result = result.replace(/<(?![img])[^>]*>/gi, "").replace(/\r\n\r\n/gi, "\n\n");
        return result;
    },
    addExpression: function (input) {
        var el = this.editor.lastElementChild;
        el.innerHTML += input;
        var range = document.createRange();
        range.selectNodeContents(el);
        range.collapse(false);
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange(range);
        el.scrollTop = 999999999999;
    },
    addContent: function (input) {

        var el = this.editor.lastElementChild;
        Range.deleteContents();
        var el = document.createElement("Content");
        el.innerHTML = input;
        var frag = document.createDocumentFragment(), node, lastNode;
        while ((node = el.firstChild)) {
            lastNode = frag.appendChild(node);
        }
        Range.insertNode(frag);
        if (lastNode) {
            Range = Range.cloneRange();
            Range.setStartAfter(lastNode);
            Range.collapse(true);
            Sel.removeAllRanges();
            Sel.addRange(Range);
        }
        el.scrollTop = 999999999999;
    },
    setContent: function (input) {
        var el = this.editor.lastElementChild;
        el.innerHTML = input;
        var range = document.createRange();
        range.selectNodeContents(el);
        range.collapse(false);
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange(range);
    },
    clearContent: function () {
        this.editor.lastElementChild.innerHTML = "";
    },
    plugins_disable: function (classname) {
        if (this.plugs_dic[classname] != undefined) {
            this.plugs_dic[classname].style.opacity = "0.3";
            this.plugs_dic[classname].onended = false;
            this.plugs_dic[classname].onclick = function () {
                return false
            };
        }
    },
    setFocusIn: function () {
        this.editor.lastElementChild.focus();
    }
};
